﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Xsl;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodRankingView : BaseAPIMethod
        {
            private int _ranking_id = 0;
            private int _studentId = 0;

            public MethodRankingView(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "rankingview"; }
            }

            protected override bool DoValidate()
            {
                return (_ranking_id > 0);
            }

            protected override void DoReadRequestParams()
            {
                string _student_Id = Component.APIRequestParams["student_id"];
                if (!string.IsNullOrEmpty(_student_Id))
                {
                    int.TryParse(_student_Id, out _studentId);
                }

                int.TryParse(Component.APIRequestParams["ranking_id"], out _ranking_id);
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    FM.N001.Account.BL.BO.View.User _statsUser = User;
                    BL.Dictionary.GroupType _group = (BL.Dictionary.GroupType)User.GroupEnumID;
                    if ((_group == PI.ZB.N1200.ELearning.BL.Dictionary.GroupType.Instructor) && (_studentId > 0))
                    {
                        _statsUser = Component.BLELearning.RBL.Account.User.View.Restore(_studentId);
                    }

                    GRankingData _GRankingData = Component.BLELearning.APIMobile.GetRankingData(_statsUser, _ranking_id);
                    if (_GRankingData != null)
                    {
                        StatusCode = StatusCodeType.OK;
                        return new GResponseData_RankingData() { Data = _GRankingData };
                    }
                    else
                    {
                        AddErrorMessage("Nie znaleziono rankingu dla ucznia.");
                        StatusCode = StatusCodeType.NotFound;
                    }
                }
                return null;
            }
        }
    }
}